import { Component, OnInit, Input } from '@angular/core';
import { ConceptServices } from '../../../services/concept-services';
import { MvpServices } from '../../../services/mvp-services';
import { RoleServices } from '../../../services/role-services'; 
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../../../store';
import { Response } from '@angular/http';
import {
  CONCEPT_CARD_POPULATING,
  ENABLE_CONCEPT_CARD_VIEW,
  SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATED
} from '../../../actions';


@Component({
  selector: 'app-concept-card-metadata',
  templateUrl: './concept-card-metadata.component.html',
  styleUrls: ['./concept-card-metadata.component.scss']
})
export class ConceptCardMetadataComponent implements OnInit {
  @Input() meta;
  mouseOvered: boolean;
  constructor(
    private ngRedux: NgRedux<IAppState>, 
    private conceptServices: ConceptServices,
    public mvpServices: MvpServices,
    private roleServices: RoleServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  anyExist(array) {
    return array !== null && array.length > 0;
  }

  getConcept(uri) {
    this.ngRedux.dispatch({
      type: CONCEPT_CARD_POPULATING
    });
    this.ngRedux.dispatch({
      type: ENABLE_CONCEPT_CARD_VIEW
    });
    /* Note: change this method to call populateConceptCard() after API property for URI is in sync */
    this.conceptServices
    .populateConceptCard(null, uri)
    .subscribe(
      (response: Response) => {
        if (response.status === 200) {
          let rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
            type: SET_CARD_DATA,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: SET_CURRENT_CONCEPT_SELECTED,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: NEW_CONCEPT_HISTORY,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: CONCEPT_CARD_POPULATED
          });
        }
    });
  }

  getAddMvpState() {
    return this.getState().conceptCard.mvpAddState;
  }

  hasMvpAddRole(mvpAnnotation) {
    var mvpBooleanState = false;
    switch(mvpAnnotation) {
      case 'inter-ontology':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddInterOntology;
        break;
      case 'property':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddProperty;
        break;
      case 'relationship':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddRelationship;
        break;
      case 'data-element':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddMappingDataElement;
        break;
      case 'algorithm':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddMappingAlgorithm;
        break;
      case 'validation':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddMappingValidation;
        break;
    }
    return this.roleServices.isTerminologist() && mvpBooleanState && this.mvpServices.isConceptMvp();
  }
  
}
